/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import com.ibm.hwmca.base.time.ChangeTimeZoneOnlyException;
import com.ibm.hwmca.base.time.ConsoleTimeChangeInProgressException;
import com.ibm.hwmca.base.time.ConsoleTimeSetException;
import com.ibm.hwmca.base.time.CustConDateTimeBean;
import com.ibm.hwmca.base.time.CustConDateTimeBeanData;
import com.ibm.hwmca.base.time.ErrorIds;
import com.ibm.hwmca.base.time.MasterTimeSource;
import com.ibm.hwmca.base.time.MasterTimeSourceExistsException;
import com.ibm.hwmca.base.time.RebootRequiredException;
import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class ConsoleTimeTasklet
extends HwmcaPanelTasklet
implements ProgressEndedListener,
ErrorIds {
    private static final String TRACE_MASKT = "XTODTSKT";
    private static final String TRACE_MASKF = "XTODTSKF";
    private static final String TRACE_MASKD = "XTODTSKD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.time.res.CustDateTimeRes";
    public static final String TZ_FILE_NAME = "com.ibm.hwmca.base.time.res.TimezoneList";
    private static final String PANEL_NAME = "CustConDateTimePanel";
    private boolean progressDismissed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ConsoleTimeTasklet.service");
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "   Handling initial request");
            try {
                CustConDateTimeBean bean = new CustConDateTimeBean(this.createBeanDataForCurrentTime());
                Trace.trace(TRACE_MASKF, "   About to request display of initial panel with bean=" + bean);
                response.replace(AUIML_FILE_NAME, PANEL_NAME, bean);
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKF, "Cannot create initial time bean:" + he);
                new FrameworkLog(ErrorIds.LOGINFO, 19).log();
                this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                response.terminate();
            }
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKF, "Termination request; about to call terminate()");
            response.terminate();
        } else {
            TaskActionEvent tae = (TaskActionEvent)request.getData("Event");
            if (tae != null) {
                String command = tae.getActionCommand();
                Trace.trace(TRACE_MASKF, "   command=" + command);
                if (command.equals("CANCEL")) {
                    response.terminate();
                } else {
                    if (command.equals("CustomizeButton")) {
                        Date newTime;
                        TimeManager tm = this.getTimeManager();
                        CustConDateTimeBeanData beanData = (CustConDateTimeBeanData)request.getData("beanData");
                        Trace.trace(TRACE_MASKF, "   beanData from request=" + beanData);
                        TimeZone tz = TimeZone.getTimeZone(beanData.getTimeZoneChoice());
                        Trace.trace(TRACE_MASKF, "   timezone = " + tz);
                        if (tz.getID().equals("UTC")) {
                            tz = TimeZone.getTimeZone("GMT");
                        }
                        if (tz.getID().equals("GMT")) {
                            tz = TimeZone.getTimeZone("GMT");
                        }
                        if (beanData.getClockChoice().equals("UTC")) {
                            tz = TimeZone.getTimeZone("GMT");
                        }
                        DateFormat df = DateFormat.getDateInstance(1);
                        df.setTimeZone(tz);
                        String date = df.format(beanData.getDateTimeNumber().getTime());
                        DateFormat tf = DateFormat.getTimeInstance(2);
                        tf.setTimeZone(tz);
                        String time = tf.format(beanData.getDateTimeNumber().getTime());
                        Trace.trace(TRACE_MASKF, "   date = " + date + "   time = " + time);
                        DateFormat dtf = DateFormat.getDateTimeInstance(1, 2);
                        dtf.setTimeZone(tz);
                        try {
                            newTime = dtf.parse(date + " " + time);
                        }
                        catch (ParseException pe) {
                            Trace.trace(TRACE_MASKF, "Got a ParseException: " + pe);
                            TaskletException te = new TaskletException(pe);
                            new FrameworkLog(ErrorIds.LOGINFO, 5, te).log();
                            throw te;
                        }
                        Trace.trace(TRACE_MASKF, "   newTime=" + dtf.format(newTime));
                        DateFormat f = DateFormat.getDateTimeInstance(1, 1);
                        f.setTimeZone(tz);
                        Trace.trace(TRACE_MASKF, "   newTime=" + f.format(newTime));
                        Trace.trace(TRACE_MASKF, "   newTime(millis)=" + newTime.getTime());
                        Calendar newTimeCalendar = Calendar.getInstance(tz);
                        newTimeCalendar.setTime(newTime);
                        Trace.trace(TRACE_MASKF, "   newTimeCalendar = " + newTimeCalendar);
                        BaseMessageTitle initialText = new BaseMessageTitle("TIMEPROGRESS.TITLE");
                        String id = "1";
                        PanelTaskletProgressListener progressListener = new PanelTaskletProgressListener(this);
                        ProgressStartEvent progressStartEvent = new ProgressStartEvent(this.getTask().getUIInfo().getUnlocalizedName(), new ProgressData[]{new ProgressData()}, 0L, (LocalizableText)initialText, id, (ProgressCancelListener)null, (ProgressEndedListener)this);
                        ProgressReportListenerImpl timeProgressReportListener = new ProgressReportListenerImpl(id, null, progressListener);
                        ConsoleTimeTasklet consoleTimeTasklet = this;
                        synchronized (consoleTimeTasklet) {
                            block64: {
                                this.progressDismissed = false;
                                boolean progressPanelUsed = false;
                                try {
                                    progressPanelUsed = tm.requestConsoleTimeSet(newTimeCalendar, progressListener, progressStartEvent, timeProgressReportListener);
                                    if (progressPanelUsed) {
                                        Trace.trace(TRACE_MASKF, "   About to wait for progress panel to be dismissed");
                                        while (!this.progressDismissed) {
                                            try {
                                                this.wait();
                                            }
                                            catch (InterruptedException exc) {}
                                        }
                                    } else {
                                        Trace.trace(TRACE_MASKF, "   Time change succeeded; tell the user");
                                        this.showSuccessMessage();
                                    }
                                    response.update(this.createBeanDataForCurrentTime());
                                }
                                catch (ConsoleTimeChangeInProgressException ctcipe) {
                                    Trace.trace(TRACE_MASKF, "   There is already a console time change in progress");
                                    this.showMessageBox(true, new BaseMessageTitle("TIMEINPROG.TITLE"), new BaseMessageText("TIMEINPROG.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    response.noAction();
                                }
                                catch (MasterTimeSourceExistsException mtsee) {
                                    Trace.trace(TRACE_MASKF, "A master time source exists; find it");
                                    HwmcaObject object = tm.getMasterTimeSource();
                                    MasterTimeSource masterTimeSource = null;
                                    if (object != null) {
                                        try {
                                            masterTimeSource = tm.getMasterTimeSourceImpl(object);
                                        }
                                        catch (HException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (masterTimeSource != null) {
                                        this.showMasterTimeSourceMessage();
                                        if (tm.setTimeChangeInProgress(true)) {
                                            try {
                                                progressPanelUsed = tm.syncConsoleTime(object, masterTimeSource, progressListener, progressStartEvent, timeProgressReportListener, false);
                                                if (progressPanelUsed) {
                                                    Trace.trace(TRACE_MASKF, "   About to wait for progress panel to be dismissed");
                                                    while (!this.progressDismissed) {
                                                        try {
                                                            this.wait();
                                                        }
                                                        catch (InterruptedException exc) {}
                                                    }
                                                }
                                                response.update(this.createBeanDataForCurrentTime());
                                            }
                                            catch (HException he) {
                                                Trace.trace(TRACE_MASKF, "Exception on time sync:" + he);
                                                this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                                response.noAction();
                                                break block64;
                                            }
                                            finally {
                                                tm.setTimeChangeInProgress(false);
                                            }
                                        }
                                        Trace.trace(TRACE_MASKF, "Time change already in progress");
                                        this.showMessageBox(true, new BaseMessageTitle("TIMEINPROG.TITLE"), new BaseMessageText("TIMEINPROG.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    }
                                    Trace.trace(TRACE_MASKF, "Master time source is gone before we could sync with it");
                                    this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                }
                                catch (ChangeTimeZoneOnlyException ctzo) {
                                    Trace.trace(TRACE_MASKF, "   Only the time zone can be changed.");
                                    LocalizableText answer = this.showMessageBox(true, new BaseMessageTitle("TIME001.TITLE"), new BaseMessageText("TIME001TZ.TEXT"), MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
                                    if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                                        try {
                                            tm.setSystemTimeAndReboot(newTimeCalendar, null);
                                            response.update(this.createBeanDataForCurrentTime());
                                        }
                                        catch (HException he) {
                                            Trace.trace(TRACE_MASKF, "   Exception on time set:" + he);
                                            this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                            response.noAction();
                                        }
                                    } else {
                                        response.noAction();
                                    }
                                }
                                catch (RebootRequiredException rre) {
                                    Trace.trace(TRACE_MASKF, "   A reboot is required for this time change");
                                    LocalizableText answer = this.showMessageBox(true, new BaseMessageTitle("TIME001.TITLE"), new BaseMessageText("TIME001.TEXT"), MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
                                    if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                                        try {
                                            tm.setSystemTimeAndReboot(newTimeCalendar, null);
                                            response.update(this.createBeanDataForCurrentTime());
                                        }
                                        catch (HException he) {
                                            Trace.trace(TRACE_MASKF, "   Exception on time set:" + he);
                                            this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                            response.noAction();
                                        }
                                    } else {
                                        response.noAction();
                                    }
                                }
                                catch (ConsoleTimeSetException ctse) {
                                    if (ctse.isProgressPanelUsed()) {
                                        Trace.trace(TRACE_MASKF, "   About to wait for progress panel to be dismissed");
                                        while (!this.progressDismissed) {
                                            try {
                                                this.wait();
                                            }
                                            catch (InterruptedException exc) {}
                                        }
                                    } else {
                                        Trace.trace(TRACE_MASKF, "An error occurred while setting the console time: " + ctse);
                                        this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    }
                                    response.noAction();
                                }
                                catch (HException he) {
                                    Trace.trace(TRACE_MASKF, "   An error occurred while setting the console time: " + he);
                                    this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    response.noAction();
                                }
                            }
                        }
                    }
                    if (command.equals("RefreshButton")) {
                        try {
                            response.update(this.createBeanDataForCurrentTime());
                        }
                        catch (HException he) {
                            Trace.trace(TRACE_MASKF, "   An error occurred while refreshing the console time: " + he);
                            new FrameworkLog(ErrorIds.LOGINFO, 20).log();
                            this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                            response.noAction();
                        }
                    } else if (command.equals("InvalidDate")) {
                        Trace.trace(TRACE_MASKF, "   The user attempted to save an invalid date or time.");
                        String beanMessage = "InvalidDate".equals((String)request.getData("DisplayMessage")) ? "TIMEMSGDATE.TEXT" : "TIMEMSGTIME.TEXT";
                        String substVar = (String)request.getData("SubstitutionVar");
                        this.showMessageBox(true, new BaseMessageTitle("TIMEMSG.TITLE"), new BaseMessageText(beanMessage, new Object[]{substVar}), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                        response.noAction();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unrecognized action command: " + command);
                        new FrameworkLog(ErrorIds.LOGINFO, 4).log();
                        response.noAction();
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "   TaskActionEvent is null.");
                new FrameworkLog(ErrorIds.LOGINFO, 4).log();
                response.noAction();
            }
        }
        Trace.trace(TRACE_MASKT, "<- ConsoleTimeTasklet.service");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> ConsoleTimeTasklet.logException(" + throwable + ")");
        new FrameworkLog(ErrorIds.LOGINFO, 2, throwable).log();
        Trace.trace(TRACE_MASKT, "<- ConsoleTimeTasklet.logException()");
    }

    protected TimeManager getTimeManager() {
        Trace.trace(TRACE_MASKT, "<> ConsoleTimeTasklet.getTimeManager()");
        return TimeManager.getTimeManager();
    }

    protected void showSuccessMessage() throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> ConsoleTimeTasklet.showSuccessMessage()");
        this.showMessageBox(true, new BaseMessageTitle("IQZA0149.TITLE"), new BaseMessageText("IQZA0149.TEXT"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
    }

    protected void showMasterTimeSourceMessage() throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> ConsoleTimeTasklet.showMasterTimeSourceMessage()");
        this.showMessageBox(true, new BaseMessageTitle("IQZA0375.TITLE"), new BaseMessageText("IQZA0376.TEXT"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> ConsoleTimeTasklet.progressEnded");
        ConsoleTimeTasklet consoleTimeTasklet = this;
        synchronized (consoleTimeTasklet) {
            this.progressDismissed = true;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- ConsoleTimeTasklet.progressEnded");
    }

    private CustConDateTimeBeanData createBeanDataForCurrentTime() throws HException {
        Trace.trace(TRACE_MASKF, "-> ConsoleTimeTasklet.createBeanDataForCurrentTime()");
        Calendar dateTimeCal = Calendar.getInstance();
        TimeZone tz = dateTimeCal.getTimeZone();
        String clockTimeString = "Local";
        String sysTimeZone = TimeManager.getTimeManager().getSystemTimeZone();
        if (sysTimeZone.equals("GMT")) {
            clockTimeString = "UTC";
        }
        CustConDateTimeBeanData beanData = new CustConDateTimeBeanData(clockTimeString, dateTimeCal, this.getTimeZoneList(), sysTimeZone);
        Trace.trace(TRACE_MASKF, "   Bean data for current time: " + beanData);
        Trace.trace(TRACE_MASKF, "<- ConsoleTimeTasklet.createBeanDataForCurrentTime()");
        return beanData;
    }

    protected String[] getTimeZoneList() throws HException {
        ResourceBundle utzBundle;
        ResourceBundle tzBundle;
        Trace.trace(TRACE_MASKF, "-> ConsoleTimeTasklet.getTimeZoneList()");
        ArrayList<String> locations = new ArrayList<String>();
        try {
            tzBundle = ResourceBundle.getBundle(TZ_FILE_NAME);
            utzBundle = ResourceBundle.getBundle(TZ_FILE_NAME, new Locale("", "", ""));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "   Exception caught: " + e);
            throw new HException(e);
        }
        Enumeration<String> tzKeys = tzBundle.getKeys();
        Enumeration<String> utzKeys = utzBundle.getKeys();
        while (tzKeys.hasMoreElements()) {
            String timezone = tzKeys.nextElement();
            String utimezone = utzKeys.nextElement();
            String location = tzBundle.getString(timezone) + "," + utzBundle.getString(utimezone);
            locations.add(location);
        }
        Collections.sort(locations, Collator.getInstance());
        String[] tzList = new String[locations.size()];
        for (int i = 0; i < locations.size(); ++i) {
            tzList[i] = (String)locations.get(i);
        }
        Trace.trace(TRACE_MASKF, "<- ConsoleTimeTasklet.getTimeZoneList()");
        return tzList;
    }
}

